<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) { header("Location: login.php"); exit(); }
require_once 'config.php';

function getFinanceStats($conn, $period) {
    $where = "1";
    if ($period == 'day')   $where = "date_created = CURDATE()";
    if ($period == 'week')  $where = "YEARWEEK(date_created, 1) = YEARWEEK(CURDATE(), 1)";
    if ($period == 'month') $where = "MONTH(date_created) = MONTH(CURDATE()) AND YEAR(date_created) = YEAR(CURDATE())";

    $sql = "SELECT 
            SUM(CASE WHEN type = 'income' THEN amount ELSE 0 END) as total_in,
            SUM(CASE WHEN type = 'expenditure' THEN amount ELSE 0 END) as total_out
        FROM transactions WHERE $where";
    $result = mysqli_query($conn, $sql);
    return mysqli_fetch_assoc($result);
}

$day = getFinanceStats($conn, 'day');
$week = getFinanceStats($conn, 'week');
$month = getFinanceStats($conn, 'month');
$all = getFinanceStats($conn, 'all');
$cash_at_hand = $all['total_in'] - $all['total_out'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Professional Finance Manager - UGX</title>
    <style>
        :root { --primary: #0f172a; --income: #16a34a; --expense: #dc2626; --cash: #ca8a04; }
        body { font-family: 'Segoe UI', Tahoma, sans-serif; background: #f1f5f9; margin: 0; color: #334155; }
        .wrapper { max-width: 1200px; margin: 30px auto; background: #fff; padding: 40px; border-radius: 16px; box-shadow: 0 4px 20px rgba(0,0,0,0.08); }
        .header { display: flex; justify-content: space-between; align-items: center; border-bottom: 2px solid #e2e8f0; padding-bottom: 20px; margin-bottom: 30px; }
        .cash-banner { background: var(--cash); color: white; padding: 30px; border-radius: 12px; text-align: center; margin-bottom: 30px; }
        .cash-banner h1 { margin: 0; font-size: 3em; }
        .report-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; margin-bottom: 40px; }
        .card { padding: 20px; border-radius: 12px; color: white; }
        .card.in { background: var(--income); }
        .card.out { background: var(--expense); }
        .card .amt { font-size: 1.6em; font-weight: bold; }
        .entry-section { background: #f8fafc; padding: 25px; border-radius: 12px; margin-bottom: 40px; border: 1px solid #e2e8f0; }
        .entry-form { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 15px; }
        input, select { padding: 12px; border: 1px solid #cbd5e1; border-radius: 8px; font-size: 1em; }
        .btn-save { background: var(--primary); color: white; border: none; font-weight: bold; cursor: pointer; border-radius: 8px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th { text-align: left; padding: 15px; background: #f1f5f9; }
        td { padding: 15px; border-bottom: 1px solid #e2e8f0; }
        .tag-in { color: var(--income); font-weight: bold; }
        .tag-out { color: var(--expense); font-weight: bold; }

        /* Modal Popup Styling */
        #pdfModal { display:none; position:fixed; z-index:100; left:0; top:0; width:100%; height:100%; background:rgba(0,0,0,0.6); }
        .modal-content { background:#fff; margin:15% auto; padding:20px; width:300px; border-radius:10px; text-align:center; }
    </style>
</head>
<body>

<div id="pdfModal">
    <div class="modal-content">
        <h3>Select Date Range</h3>
        <form action="print_pdf.php" method="GET" target="_blank">
            <input type="date" name="start_date" value="<?php echo date('Y-m-01'); ?>" required><br><br>
            <input type="date" name="end_date" value="<?php echo date('Y-m-d'); ?>" required><br><br>
            <button type="submit" class="btn-save" onclick="closeModal()">Generate Report</button>
            <button type="button" onclick="closeModal()" style="background:none; border:none; color:red; cursor:pointer;">Cancel</button>
        </form>
    </div>
</div>

<div class="wrapper">
    <div class="header">
        <h2>UGX Financial Dashboard</h2>
        <div>
            <button onclick="openModal()" style="background:#000; color:#fff; padding:10px 20px; border-radius:8px; border:none; cursor:pointer; margin-right:10px;">Export PDF</button>
            <a href="logout.php" style="color:red; text-decoration:none; font-weight:bold;">Logout</a>
        </div>
    </div>

    <div class="cash-banner">
        <h4>CURRENT MONEY AT HAND</h4>
        <h1>UGX <?php echo number_format($cash_at_hand, 0); ?></h1>
    </div>

    <h3>Income Summary</h3>
    <div class="report-grid">
        <div class="card in"><h4>Daily</h4><div class="amt">UGX <?php echo number_format($day['total_in'], 0); ?></div></div>
        <div class="card in"><h4>Weekly</h4><div class="amt">UGX <?php echo number_format($week['total_in'], 0); ?></div></div>
        <div class="card in"><h4>Monthly</h4><div class="amt">UGX <?php echo number_format($month['total_in'], 0); ?></div></div>
    </div>

    <h3>Expenditure Summary</h3>
    <div class="report-grid">
        <div class="card out"><h4>Daily</h4><div class="amt">UGX <?php echo number_format($day['total_out'], 0); ?></div></div>
        <div class="card out"><h4>Weekly</h4><div class="amt">UGX <?php echo number_format($week['total_out'], 0); ?></div></div>
        <div class="card out"><h4>Monthly</h4><div class="amt">UGX <?php echo number_format($month['total_out'], 0); ?></div></div>
    </div>

    <div class="entry-section">
        <h3>New Transaction Entry</h3>
        <form action="save.php" method="POST" class="entry-form">
            <input type="text" name="title" placeholder="Description" required>
            <input type="number" name="amount" placeholder="Amount (UGX)" required>
            
            <select name="category" id="catSelect" onchange="checkNewCat(this.value)">
                <?php
                $cats = mysqli_query($conn, "SELECT name FROM categories ORDER BY name ASC");
                while($c = mysqli_fetch_assoc($cats)) {
                    echo "<option value='{$c['name']}'>{$c['name']}</option>";
                }
                ?>
                <option value="NEW_CAT" style="color:blue; font-weight:bold;">+ Add New Category</option>
            </select>
            
            <input type="text" name="new_category_name" id="newCatInput" placeholder="Enter New Category Name" style="display:none;">

            <select name="type">
                <option value="income">Income</option>
                <option value="expenditure">Expenditure</option>
            </select>
            <input type="date" name="date_created" value="<?php echo date('Y-m-d'); ?>">
            <button type="submit" name="submit" class="btn-save">Save Transaction</button>
        </form>
    </div>

    <h3>Transaction History</h3>
<table>
    <thead>
        <tr>
            <th>Date</th>
            <th>Description</th>
            <th>Category</th>
            <th>Type</th>
            <th>Amount</th>
            <th style="text-align:center;">Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $history = mysqli_query($conn, "SELECT * FROM transactions ORDER BY date_created DESC LIMIT 15");
        
        if (mysqli_num_rows($history) > 0) {
            while($row = mysqli_fetch_assoc($history)) {
                // Fix for Localhost Warnings: Provide defaults if data is missing
                $id   = $row['id'] ?? 0;
                $date = $row['date_created'] ?? 'N/A';
                $title= htmlspecialchars($row['title'] ?? 'No Description');
                $cat  = htmlspecialchars($row['category'] ?? 'General');
                $type = $row['type'] ?? 'expenditure';
                $amt  = $row['amount'] ?? 0;

                $typeClass = ($type == 'income') ? 'tag-in' : 'tag-out';
                $displayAmt = number_format($amt, 0);

                echo "<tr>
                    <td>$date</td>
                    <td>$title</td>
                    <td>$cat</td>
                    <td class='$typeClass'>".ucfirst($type)."</td>
                    <td class='$typeClass'>UGX $displayAmt</td>
                    <td style='text-align:center;'>
                        <button onclick='confirmDelete($id, \"$title\", \"$displayAmt\", \"$type\")' class='btn-delete-ui'>Delete</button>
                    </td>
                </tr>";
            }
        } else {
            echo "<tr><td colspan='6' style='text-align:center;'>No records found.</td></tr>";
        }
        ?>
    </tbody>
</table>

<script>
function confirmDelete(id, title, amount, type) {
    const impact = (type === 'income') ? 
        'DECREASE (Money will be removed from your balance)' : 
        'INCREASE (Expenses will be reversed and money returned)';

    const msg = `⚠️ ADMINISTRATIVE WARNING: PERMANENT DELETION ⚠️\n\n` +
                `You are about to delete: ${title}\n` +
                `Amount: UGX ${amount}\n\n` +
                `FINANCIAL IMPACT:\n` +
                `Your total Cash at Hand will ${impact}.\n\n` +
                `Are you absolutely sure you want to proceed? This cannot be undone.`;

    if (confirm(msg)) {
        if (confirm("FINAL VERIFICATION: Confirming this will permanently alter your financial records. Proceed?")) {
            window.location.href = 'actions.php?delete_id=' + id;
        }
    }
}
</script>

<style>
    .btn-delete-ui {
        background: #fee2e2;
        color: #991b1b;
        border: 1px solid #f87171;
        padding: 5px 12px;
        border-radius: 6px;
        cursor: pointer;
        font-weight: bold;
        transition: 0.2s;
    }
    .btn-delete-ui:hover {
        background: #991b1b;
        color: white;
    }
</style>
</div>

<script>
function openModal() { document.getElementById('pdfModal').style.display = 'block'; }
function closeModal() { document.getElementById('pdfModal').style.display = 'none'; }
function checkNewCat(val) {
    var input = document.getElementById('newCatInput');
    input.style.display = (val === 'NEW_CAT') ? 'block' : 'none';
    if(val === 'NEW_CAT') input.required = true;
}
</script>
</body>
</html>