<?php
session_start();
include 'config.php';
if (!isset($_SESSION['admin_logged_in'])) exit("Unauthorized");

// FIX: Provide default dates if the array keys are missing
$start = $_GET['start_date'] ?? date('Y-m-01');
$end = $_GET['end_date'] ?? date('Y-m-t');

// Secure the variables for the query
$start = mysqli_real_escape_string($conn, $start);
$end = mysqli_real_escape_string($conn, $end);

// Fetch Transactions for the specific range
$sql = "SELECT * FROM transactions WHERE date_created BETWEEN '$start' AND '$end' ORDER BY date_created ASC";
$result = mysqli_query($conn, $sql);

// Calculate Totals - Ensure the word 'expenditure' matches your database ENUM
$inc_query = "SELECT SUM(amount) as total FROM transactions WHERE type='income' AND date_created BETWEEN '$start' AND '$end'";
$exp_query = "SELECT SUM(amount) as total FROM transactions WHERE type='expenditure' AND date_created BETWEEN '$start' AND '$end'";

$inc = mysqli_fetch_assoc(mysqli_query($conn, $inc_query))['total'] ?? 0;
$exp = mysqli_fetch_assoc(mysqli_query($conn, $exp_query))['total'] ?? 0;
?>
<!DOCTYPE html>
<html>
<head>
    <title>Financial Report: <?php echo $start; ?> to <?php echo $end; ?></title>
    <style>
        body { font-family: 'Helvetica', Arial, sans-serif; padding: 40px; color: #333; }
        .text-center { text-align: center; }
        .summary-box { 
            margin: 20px 0; 
            border: 2px solid #444; 
            padding: 20px; 
            background: #f8f9fa; 
            display: flex; 
            justify-content: space-around;
        }
        .summary-item { text-align: center; }
        .summary-item strong { display: block; font-size: 1.2em; margin-top: 5px; }
        table { width: 100%; border-collapse: collapse; margin-top: 30px; }
        th, td { border: 1px solid #999; padding: 12px; text-align: left; }
        th { background: #34495e; color: white; }
        .income-text { color: #27ae60; font-weight: bold; }
        .expense-text { color: #c0392b; font-weight: bold; }
        @media print {
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="text-center">
        <h1 style="margin-bottom: 5px;">FINANCIAL STATEMENT</h1>
        <p style="margin-top: 0; color: #666;">Report Period: <strong><?php echo date('d M Y', strtotime($start)); ?></strong> to <strong><?php echo date('d M Y', strtotime($end)); ?></strong></p>
    </div>

    <div class="summary-box">
        <div class="summary-item">
            TOTAL INCOME
            <strong style="color: #27ae60;">UGX <?php echo number_format($inc, 0); ?></strong>
        </div>
        <div class="summary-item">
            TOTAL EXPENDITURE
            <strong style="color: #c0392b;">UGX <?php echo number_format($exp, 0); ?></strong>
        </div>
        <div class="summary-item">
            NET BALANCE
            <strong style="color: #2c3e50;">UGX <?php echo number_format($inc - $exp, 0); ?></strong>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Description</th>
                <th>Category</th>
                <th>Type</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php if (mysqli_num_rows($result) > 0): ?>
                <?php while($row = mysqli_fetch_assoc($result)): ?>
                <tr>
                    <td><?php echo date('d-m-Y', strtotime($row['date_created'])); ?></td>
                    <td><?php echo htmlspecialchars($row['title']); ?></td>
                    <td><?php echo htmlspecialchars($row['category'] ?? 'General'); ?></td>
                    <td class="<?php echo ($row['type'] == 'income') ? 'income-text' : 'expense-text'; ?>">
                        <?php echo ucfirst($row['type']); ?>
                    </td>
                    <td><strong>UGX <?php echo number_format($row['amount'], 0); ?></strong></td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5" style="text-align:center;">No transactions found for this period.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div style="margin-top: 50px; font-size: 0.8em; color: #888; text-align: center;">
        Report Generated on <?php echo date('Y-m-d H:i:s'); ?>
    </div>
</body>
</html>